package gov.va.med.mhv.phr.allergy.model;

import org.displaytag.decorator.TableDecorator;

/**
 * Defines the order in which blended allergy views are ordered.
 * @author                   
 */
public class AllergyBlendedRowSorter extends MultiPropertyRowSorter {

    private static final SortOrder[] SORT_ORDER = {
        new SortOrder("blendedCollectedOn", false),
        new SortOrder("blendedReactant", true),
        new SortOrder("blendedAllergyReaction", true),
        new SortOrder("blendedFacilityName", true),
        new SortOrder("blendedAllergySource", true)
    };

    public AllergyBlendedRowSorter(String propertyName, TableDecorator tableDecorator,
        boolean isAscending)
    {
        super(propertyName, tableDecorator, isAscending);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.model.MultiplePropertySorter#getSortOrder()
     */
    @Override
    protected SortOrder[] getSortOrder()
    {
        return SORT_ORDER;
    }

}
